<?php
/*
Theme Name: t3
Unique Name: t3
Theme URI: https://t3-marketing.com
Author: t3
Author URI: https://t3-marketing.com
Version: 1.0
Description: all in one Social Marketing Platform. 
*/
?>
<!DOCTYPE html>
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->


<!--<![endif]-->
<html class="no-js" lang="en">

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   
	<title><?php echo $this->config->item('product_name'); if($this->config->item('slogan')!='') echo " | ".$this->config->item('slogan')?></title>
	<meta name="description" content="<?php echo $this->config->item('slogan'); ?>">
	<meta name="author" content="<?php echo $this->config->item('institute_address1');?>">

	<!-- Mobile Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<!-- Favicon -->
	<link rel="shortcut icon" href="<?php echo base_url();?>assets/img/favicon.png">

    <!--====== Animate CSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/animate.css">
	
	<link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/slick.css">
	  <!--====== slideCSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/swiper.min.css">    
    <!--====== lineicons CSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/lineicons.css">
        
    <!--====== Bootstrap CSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/bootstrap-extended.min.css">
    <!--====== Default CSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/default.css">
    
    <!--====== Style CSS ======-->
    <link rel="stylesheet" href="<?php echo base_url();?>assets/t3/assets/css/style.css">
</head>

<body>
    <!--[if IE]>
    <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->
    
    <!--====== PRELOADER PART START ======-->

    <div class="preloader">
        <div class="loader">
            <div class="ytp-spinner">
                <div class="ytp-spinner-container">
                    <div class="ytp-spinner-rotator">
                        <div class="ytp-spinner-left">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                        <div class="ytp-spinner-right">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--====== PRELOADER PART ENDS ======-->
    
    <!--====== HEADER PART START ======-->

    <header class="header-area">
        <div class="navbar-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <nav class="navbar navbar-expand-lg">
                            <a class="navbar-brand" href="<?php echo base_url(); ?>">
                            <img style="max-height:45px !important" src="<?php echo base_url();?>assets/img/logo.png" alt="<?php echo $this->config->item('product_name');?>">
                        
                            </a>
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                            </button>

                            <div class="collapse navbar-collapse sub-menu-bar" id="navbarSupportedContent">
                                <ul id="nav" class="navbar-nav ml-auto" style="text-transform: uppercase">
                                    <li class="nav-item active">
                                        <a class="page-scroll" href="<?php echo base_url(); ?>"><?php echo $this->lang->line('Home'); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#why"><?php echo $this->lang->line('WHY CHAT MARKETING'); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#features"><?php echo $this->lang->line('Features'); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#screenshots"><?php echo $this->lang->line('Screenshots'); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#service"><?php echo $this->lang->line('PRICING'); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="<?php echo base_url('blog'); ?>"><?php echo $this->lang->line('Blog'); ?></a>
                                    </li>
                                      
                                  <li class="nav-item">
                                        <a class="page-scroll " href="<?php echo base_url('home/login'); ?>"><?php echo $this->lang->line('Login'); ?></a>
                                    </li>
                                    
                                </ul>
                            </div> <!-- navbar collapse -->
                        </nav> <!-- navbar -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
        </div> <!-- navbar area -->
        <script type="text/javascript" src="https://codeonic.com/js/2waychat/plugin-116040528825.js"></script><div style="z-index:9999999"><div class="fb-customerchat" page_id="111455044090632" ref="CODEONIC.COM" greeting_dialog_display="show" theme_color="#ffffff" logged_in_greeting="CHAT WITH US!" greeting_dialog_delay="1"></div></div>

        <div id="home" class="header-hero bg_cover d-lg-flex align-items-center">
            
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
            <div class="shape shape-4"></div>
            <div class="shape shape-5"></div>
            <div class="shape shape-6"></div>
            
            <div class="container">
                <div class="row align-items-center justify-content-center justify-content-lg-between">
                    <div class="col-lg-6 col-md-10">
                        <div class="header-hero-content">
                            <h3 style="text-transform: uppercase;" class="header-title wow fadeInLeftBig" data-wow-duration="1.3s" data-wow-delay="0.2s"><span class="T1">COMPLETE MESSENGER</span> <span class="T2"> MARKETING  </span></h3>
                            <p class="text wow fadeInLeftBig" data-wow-duration="1.3s" data-wow-delay="0.6s">The leading no-code chatbot platform for Facebook, Instagram, and Messenger.
							Automate Facebook Messenger to engage 24/7 with your customers, increase sales, reduce software costs and grow your business.  </p>
                            <ul class="d-flex">
                                <li><a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn wow fadeInLeftBig" data-wow-duration="1.3s" data-wow-delay="0.8s">GET STARTED FREE</a></li>
                            </ul>
                        </div> <!-- header hero content -->
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-10">
                        <div class="header-image">
                           <video class="app" muted="" playsinline="" autoplay="" loop=""><source src="<?php echo base_url();?>assets/t3/assets/images/header_app.webm" type="video/webm"><source src="<?php echo base_url();?>assets/t3/assets/images/header_app.mp4" type="video/mp4"></video>
								

						   <div class="image-shape wow fadeInRightBig" data-wow-duration="1.3s" data-wow-delay="0.8s">
                                <img src="<?php echo base_url();?>assets/t3/assets/images/image-shape.svg" alt="shape">
								
                            </div>
                        </div> <!-- header image -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
            <div class="header-shape-1"></div> <!-- header shape -->
            <div class="header-shape-2">
                <img src="<?php echo base_url();?>assets/t3/assets/images/header-shape-2.svg" alt="shape">
            </div> <!-- header shape -->
        </div> <!-- header hero -->
    </header>

    <!--====== HEADER PART ENDS ======-->
    
    <!--====== SERVICES PART START ======-->
    
    <section id="why" class="services-area pt-110 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-title text-center pb-25">
                        <h3 class="title">1.3 Billion People Use Messenger Every Day</h3>
                        <p class="text">Everything You Need In One Place, To Reach Your Customer</p>
                        <p class="text">Learn How To Reach Them</p>
                    </div> <!-- section title -->
                </div>
            </div> <!-- row -->
            <div class="row">
                <div class="col-lg-4 col-sm-6">
                    <div class="single-services services-color-1 text-center mt-30 wow fadeInUpBig" data-wow-duration="1.3s" data-wow-delay="0.2s">
                        <div class="services-icon d-flex align-items-center justify-content-center">
                          <i class='lni lni-money-protection'></i>
                        </div>
                        <div class="services-content">
                            <h4 class="services-title"><a href="#">Increase sales</a></h4>
                            <p class="text"> With 80% open rates and 25% CTR, Messenger beats every other channel like email campaign and broadcasts</p>
							</br>
							<a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn">GET STARTED FREE</a>
                        </div>
                    </div> <!-- single services -->
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="single-services services-color-2 text-center mt-30 wow fadeInUpBig" data-wow-duration="1.3s" data-wow-delay="0.4s">
                        <div class="services-icon d-flex align-items-center justify-content-center">
                           <i class='lni lni-rocket'></i>
                        </div>
                        <div class="services-content">
                            <h4 class="services-title"><a href="#">Get More Leads</h4>
                            <p class="text">Engage with prospects 24/7. Automate sales or connect warm leads to a sales rep in a live chat</p>
							</br>
							<a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn">GET STARTED FREE</a>
                        </div>
                    </div> <!-- single services -->
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="single-services services-color-3 text-center mt-30 wow fadeInUpBig" data-wow-duration="1.3s" data-wow-delay="0.6s">
                        <div class="services-icon d-flex align-items-center justify-content-center">
                           <i class='lni lni-network'></i>
                        </div>
                        <div class="services-content">
                            <h4 class="services-title"><a href="#">Automate FAQs</a></h4>
                            <p class="text">Increase customer satisfaction and reduce support costs through interactive and tailored content</p>
							</br>
							<a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn">GET STARTED FREE</a>
                        </div>
                    </div> <!-- single services -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
    
    <!--====== SERVICES PART ENDS ======-->
    
    <!--====== ABOUT PART START ======-->
    
    <section id="about" class="about-area pt-70 pb-120">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="about-image mt-50 wow fadeInLeftBig" data-wow-duration="1.3s" data-wow-delay="0.5s">
                        <div class="about-shape"></div>
                        <video class="app" muted="" playsinline="" autoplay="" loop=""><source src="<?php echo base_url();?>assets/t3/assets/images/ecommerce-app.webm" type="video/webm"><source src="<?php echo base_url();?>assets/t3/assets/images/ecommerce-app.mp4" type="video/mp4"></video>
								

                    </div> <!-- about image -->
                </div>
                <div class="col-lg-6">
                    <div class="about-content mt-50 wow fadeInRightBig" data-wow-duration="1.3s" data-wow-delay="0.5s">
                        <div class="section-title">
                            <h3 class="title">Ecommerce Shop Inside Messenger </h3>
                            <p class="text">First built-in Ecommerce platform for selling product inside Facebook Messenger. Build your local ecommerce store, sell from Facebook Messenger.  Create promotions & take payments all within messenger.</p>
                        </div> <!-- section title -->
						</br>
						<div class="pricing-list">
<ul class="list">
<li><i class='lni lni-checkmark-circle'></i>  Create stores and sell you products in Messenger</li>
<li><i class='lni lni-checkmark-circle'></i> Product management</li>
<li><i class='lni lni-checkmark-circle'></i> Category & attribute management</li>
<li><i class='lni lni-checkmark-circle'></i> Coupon system</li>
<li><i class='lni lni-checkmark-circle'></i> Cash On Delivery, Manual/Bank Payment</li>
<li><i class='lni lni-checkmark-circle'></i> Order management </li>
 <p> (shipping, delivery, reject & accept order)</p>
<li><i class='lni lni-checkmark-circle'></i> Complete Order reciept in Messenger</li>



</ul>
						
                        <a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn">GET STARTED FREE</a>
                    </div> <!-- about content -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
    
    <!--====== ABOUT PART ENDS ======-->
    
<section id="features" class="features-area pt-110">
		<div id="shape">
        <div class="shape-1"></div>
        <div class="shape-2"></div>
        <div class="shape-3"></div>
        <div class="shape-4"></div>
        <div class="shape-5"></div>
        <div class="shape-6"></div>
        <div class="shape-7"></div>
        </div>
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-7">
<div class="section-title text-center pb-25">
<h3 class="title">Awesome Key Features</h3>
<p class="text">Complete Facebook, Instagram and Messenger marketing automation tool</p>
</div> 
</div>
</div> 
<div class="row justify-content-center">
<div class="col-lg-6">
<div class="features-items nav" role="tablist">
<div class="single-features features-color-1 d-sm-flex mt-30 wow fadeInUpBig" data-toggle="tab" href="#inbox" role="tab" aria-controls="inbox" data-wow-duration="1.3s" data-wow-delay="0.2s">
<div class="features-icon d-flex justify-content-center align-items-center">
<i class='lni lni-share'></i>
</div>

<div class="features-content media-body">
<h4 class="features-title">AUTO PRIVATE INBOX REPLY</h4>
<p class="text">Engage with prospects 24/7, increase page response time by reply inbox message based on keywords.</p>
</div>
</div> 
<div class="single-features features-color-2 d-sm-flex mt-30 wow fadeInUpBig" data-toggle="tab" href="#sharing" role="tab" aria-controls="sharing" data-wow-duration="1.3s" data-wow-delay="0.4s">
<div class="features-icon d-flex justify-content-center align-items-center">
<i class='lni lni-rss-feed'></i>
</div>
<div class="features-content media-body">
<h4 class="features-title">AUTO CONTENT SCHEDULE SHARING</h4>
<p class="text">Create news, blog web campaigns and automatic daily website content sharing to multi-page.</p>
</div>
</div> 
<div class="single-features features-color-2 d-sm-flex mt-30 wow fadeInUpBig" data-toggle="tab" href="#comment" role="tab" aria-controls="comment" data-wow-duration="1.3s" data-wow-delay="0.6s">
<div class="features-icon d-flex justify-content-center align-items-center">
<i class='lni lni-comments-reply'></i>
</div>
<div class="features-content media-body">
<h4 class="features-title">AUTO COMMENT LIKE REPLY</h4>
<p class="text">Allows to send auto like comment reply to your post’s commenters with Auto Private Reply Template Message.</p>
</div>
</div> 
<div class="single-features features-color-3 d-sm-flex mt-30 wow fadeInUpBig" data-toggle="tab" href="#ecommerce" role="tab" aria-controls="ecommerce" data-wow-duration="1.3s" data-wow-delay="0.8s">
<div class="features-icon d-flex justify-content-center align-items-center">
<i class='lni lni-cart-full'></i>
</div>
<div class="features-content media-body active">
<h4 class="features-title">ECOMMERCE INSIDE MESSENGER </h4>
<p class="text">Easily build your local ecommerce store, sell from Facebook Messenger. Integrate Ecommerce Store in Messenger BOT.</p>
</div>
</div> 
</div> 
</div>
<div class="col-lg-6 col-md-6 tab-content">
<div class="features-image wow fadeInRightBig" data-wow-duration="1.3s" data-wow-delay="0.5s">

<div class="tab-pane active" id="ecommerce" role="tabpanel" data-wow-duration="1.3s" data-wow-delay="0.8s">
<img class="image" data-wow-duration="1.3s" data-wow-delay="0.8s" src="<?php echo base_url();?>assets/t3/assets/images/shop.png" alt="Messeger Online Store">    
 </div>
<div class="tab-pane" id="inbox" role="tabpanel" data-wow-duration="1.3s" data-wow-delay="0.8s">
<img class="image" src="<?php echo base_url();?>assets/t3/assets/images/privatereply.png" alt="Inbox Reply">    
 </div>
<div class="tab-pane " id="sharing" role="tabpanel" data-wow-duration="1.3s" data-wow-delay="0.8s">
<img class="image" src="<?php echo base_url();?>assets/t3/assets/images/websharing.png" alt="Contact Sharing">    
 </div>
<div class="tab-pane " id="comment" role="tabpanel" data-wow-duration="1.3s" data-wow-delay="0.8s">
<img class="image" src="<?php echo base_url();?>assets/t3/assets/images/commentlike.png" alt="Auto Comment">    
 </div>

</div> 

</div>
</div> 
</div> 
</section>


<section id="screenshots" class="screenshots-area pt-110 pb-120">
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-7">
<div class="section-title text-center pb-45">
<h3 class="title">Grow Your Business</h3>
<p class="text">Build a Bot in Minutes. Automate business inquiries, increase 10x more sales,  you can build the content flow to engage and build relationship with your customers.</p>
</div> 
</div>
</div> 
<div class="row">
<div class="col-lg-12">
<div class="screenshot-slider">
<div class="swiper-container">
<div class="swiper-wrapper">
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot1.jpg" alt="screenshot">
</div>
</div>
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot2.jpg" alt="screenshot">
</div>
</div> 
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot3.jpg" alt="screenshot">
</div>
</div> 
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot4.jpg" alt="screenshot">
</div>
</div> 
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot5.jpg" alt="E Commerce-Order Cart">
</div>
</div> 
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot6.jpg" alt="E Commerce-Payment">
</div>
</div> 
<div class="swiper-slide">
<div class="slider-image">
<img src="<?php echo base_url();?>assets/t3/assets/images/screenshot7.jpg" alt="E Commerce-Product Page">
</div>
</div> 
</div> 

<div class="swiper-pagination"></div>
<div class="screenshot-frame d-none d-sm-block">
<img src="<?php echo base_url();?>assets/t3/assets/images/app-frame.png" alt="frame">
</div> 
</div> 
</div> 
</div>
</div> 
</div> 
</section>


<section id="testimonial" class="<?php if($this->config->item('display_review_block') == '0') echo 'hidden';?> testimonial-area pt-110 pb-120">
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-7">
<div class="section-title text-center pb-45">
<h3 class="title"><?php echo $this->lang->line("User Reviews"); ?></h3>
<p class="text"><?php echo $this->lang->line("Learn From Other Business Owners"); ?></p>
</div> 
</div>
</div> 
<div class="row justify-content-center">
<div class="col-lg-9">
<div class="testimonial-wrapper">
<div class="testimonial-content">
<?php 
                                $customerReview = $this->config->item('customer_review');
                                $ct=0;
							    foreach($customerReview as $singleReview) : 
                                $ct++;
                                $original = $singleReview[2];
                                $base     = base_url();

                                if (substr($original, 0, 4) != 'http') {
                                    $img = $base.$original;
                                } else {
                                   $img = $original;
                                }

                            ?>
<div class="single-testimonial-content text-center">
<div class="testimonial-quote">
 <img class="svg" src="<?php echo base_url();?>assets/t3/assets/images/icon-quote.svg" alt="quote">
</div>
<div class="testimonial-text">
<p class="text">
  <?php 
                                                if(strlen($singleReview[3]) > 200 ) {
                                                    $str = substr($singleReview[3],0,180);
                                                    echo $str.". . ."."<a class='exe' style='cursor: pointer' data-toggle='modal' data-target=#myModal".$ct.">see more</a>";
                                                
                                                } else {
                                                    echo $str = $singleReview[3];
                                                }
                                                
                                            ?>

<h4 class="holder-name"><?php echo $singleReview[0]; ?></h4>
<span class="sub-title"><?php echo $singleReview[1]; ?></span>
</div>
</div> 
  <?php endforeach; ?>
</div> 







<div class="testimonial-author">
 <?php 
                                $customerReview = $this->config->item('customer_review');
                                $ct=0;
							    foreach($customerReview as $singleReview) : 
                                $ct++;
                                $original = $singleReview[2];
                                $base     = base_url();

                                if (substr($original, 0, 4) != 'http') {
                                    $img = $base.$original;
                                } else {
                                   $img = $original;
                                }

                            ?>
<div class="single-testimonial-author">
<img src="<?php echo $img; ?>" alt="reviewer">

</div> 
  <?php endforeach; ?>
</div> 


</div> 


</div>
</div> 
</div> 
</section>

 <!--====== PRICING START ======-->
     <?php
    if(!empty($pricing_table_data)) : 
    ?>
<section id="service" class="pricing-area pt-110">
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-7">
<div class="section-title text-center pb-30">
<h3 class="title">Try Codeonic Platform for Free </h3>
<p class="text">Level up with features that grow with you </p>
</div> 
</div>
</div> 
<div class="row justify-content-center">
     <?php 
                $i=0;
                $classes=array(1=>"tiny",2=>"small",3=>"medium",4=>"pro");
                foreach($pricing_table_data as $pack) :    
                $i++;   
            ?>
            
<div class="col-lg-4 col-md-7 col-sm-9 ">
<div style="padding: 12px" class="<?php echo $pack["package_name"]; ?> single-pricing pricing-active text-center mt-30 wow fadeIn price-plan1" data-wow-duration="1.3s" data-wow-delay="0.2s">
<div class="pricing-title">
<h4 class="title"><i class="lni lni-crown"></i>  <?php echo $pack["package_name"]; ?></h4>
</div>
<div class="pricing-price" >
    <p></p>
<span class="price"><?php echo $curency_icon; ?> <?php echo $pack["price"]?></span>
<P><?php echo $pack["validity"]?> <?php echo $this->lang->line("days"); ?></P>
<p></p>
</div>
<div class="pricing-list">
<ul class="list" style="
    height: 400px;
    overflow: auto;
">
 <?php 
                                $module_ids=$pack["module_ids"];
                                $monthly_limit=json_decode($pack["monthly_limit"],true);
                                $module_names_array=$this->basic->execute_query('SELECT module_name,id FROM modules WHERE FIND_IN_SET(id,"'.$module_ids.'") > 0  ORDER BY module_name ASC');

                                foreach ($module_names_array as $row) : ?>
                                <li     style="border-bottom: 1px solid #0dd4b5">
                                    <i class='lni lni-checkmark-circle'></i>&nbsp;
                                    <?php 
                                        $limit=0;
                                        $limit=$monthly_limit[$row["id"]];

                                        if($limit=="0") 
                                            $limit2="<b style='
    float: right'>".$this->lang->line("unlimited")."</b>";
                                        else 
                                            $limit2=$limit;

                                        if($row["id"]!="1" && $limit!="0") 
                                            
                                            $limit2="<b  style='
    float: right'>".$limit2."/".$this->lang->line("month")."</b>";
                                            echo $this->lang->line($row["module_name"]);

                                        if($row["id"]!="13" && $row["id"]!="14" && $row["id"]!="16") 
                                            echo " : <b  style='
    float: right'>". $limit2."</b>"."<br>";
                                        else 
                                            echo "<br>";
                                    ?>
                                </li>
                            <?php endforeach; ?>
</ul>
</div>
<div class="pricing-btn">
<a class="main-btn main-btn-2" href="<?php echo base_url('home/login'); ?>" >GET STARTED</a>
</div>
</div> 
</div>

 <?php
                // if($i%4==0) break;
                endforeach;
            ?>
</div> 
</div> 
</section>
    <?php endif; ?>
    
    <!--====== PRICING FB ENDS ======-->
    
    
 
    <!--====== PRICING ENDS ======-->
<!--====== CONTACT PART START ======-->

    <section id="contact" class="contact-area pt-95 pb-100" style="<?php if($this->config->item('display_video_block') == '0' && $this->config->item('display_review_block') == '0' ) echo 'background-color: #fff'; elseif($this->config->item('display_video_block') == '0') echo 'background-color: #f5f4f4'; else echo 'background-color: #fff'; ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="contact mt-30">
                        <h4 class="contact-title"><?php echo $this->lang->line('Contact'); ?></h4>
                        <p class="text" style="line-height: 45px">Start building meaningful relationships with your customers through our software. Full guide with video, easy how to learn and use our system.</p></br>
                       
                    </div> <!-- contact -->
                </div>
                <div class="col-lg-6">
                    <div class="contact-form form-style-one mt-15">
					 <div class="form-input mt-15">
						 <?php 
										if($this->session->userdata('mail_sent') == 1) {
										echo "<div class='alert alert-success text-center'>".$this->lang->line("we have received your email. we will contact you through email as soon as possible")."</div>";
										$this->session->unset_userdata('mail_sent');
										}
									?>
							</div>
                        <form action="<?php echo site_url("home/email_contact"); ?>" method="post">
						<div class="form-input mt-15">
                                <div class="input-items default">
                                        <input type="text" class="form-control" required id="subject" <?php echo set_value("subject"); ?> placeholder="<?php echo $this->lang->line("message subject");?>" name="subject">
                                            
                                    
                                </div>
                            </div> <!-- form input -->
                            <div class="form-input mt-15">
                                <div class="input-items default">
                                       <input type="email" class="form-control" required id="email" <?php echo set_value("email"); ?> placeholder="<?php echo $this->lang->line("email");?>" name="email">
                                   
                                </div>
                            </div> <!-- form input -->
                            <div class="form-input mt-15">
                                <div class="input-items default">
                                    <input type="number" class="form-control" step="1" required id="captcha" <?php echo set_value("captcha"); ?> placeholder="<?php echo $contact_num1. "+". $contact_num2." = ?"; ?>" name="captcha">
													<span class="red">
														<?php 
														if(form_error('captcha')) 
															echo form_error('captcha'); 
														else  
														{ 
															echo $this->session->userdata("contact_captcha_error"); 
															$this->session->unset_userdata("contact_captcha_error"); 
														} 
														?>
													</span>
                              
                                </div>
                            </div> <!-- form input -->
							
                            <div class="form-input mt-15">
                                <div class="input-items default">
                                       <textarea class="form-control" rows="3" required id="message" <?php echo set_value("message"); ?> placeholder="  <?php echo $this->lang->line("message");?>" name="message"></textarea>
                                            
                                   
                                </div>
                            </div> <!-- form input -->
                            <p class="form-message"></p>
                            <div class="form-input standard-buttons mt-20">
                                <button class="main-btn standard-two" type="submit"><?php echo $this->lang->line("SEND");?></button>
                            </div> <!-- form input -->
                        </form>
                    </div> <!-- contact form -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </section>
 
 
 <section id="faq"class="about-area pt-70 pb-120">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-7 collapse-icon accordion-icon-rotate">
          <h3 class="card-title text-center">Frequently Asked Questions</h3>
        
        <div class="justify-content-center">
          <div class="accordion" id="accordionExample" data-toggle-hover="true">
            <div class="collapse-margin">
              <div class="card-header collapsed" id="headingOne" data-toggle="collapse" role="button" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                <span class="lead collapse-title">
                 What is a Facebook Messenger bot?
                </span>
              </div>

              <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample" style="">
                <div class="card-body">
                  A bot is a series of automated conversations that can answer common questions from your customers over Facebook Messenger. 
                  This could be to explain what your product or service does, gather information about the customer, deliver helpful content, 
                  or nurture them towards a sale.
                </div>
              </div>
            </div>
            <div class="collapse-margin">
              <div class="card-header collapsed" id="headingTwo" data-toggle="collapse" role="button" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                <span class="lead collapse-title">
                  What can a bot do for my business?

                </span>
              </div>
              <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample" style="">
                <div class="card-body">
                  Our bots allow you to automatically welcome new users, send them content, schedule messages, 
                  respond to specific keywords, and much more.
                </div>
              </div>
            </div>
            <div class="collapse-margin">
              <div class="card-header" id="headingThree" data-toggle="collapse" role="button" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                <span class="lead collapse-title">
                  Why do I need a Messenger bot?

                </span>
              </div>
              <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                <div class="card-body">
                  Every day it’s becoming harder to reach your audience. People open less email and social media is so noisy your organic reach is often 
                  less than 10% of your audience. Facebook Messenger bots solve this problem by providing personalized 
                  and automated conversations with your customers. It is real-time, interactive, and has 80% open rates.
                </div>
              </div>
            </div>
            <div class="collapse-margin">
              <div class="card-header" id="headingFour" data-toggle="collapse" role="button" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                <span class="lead collapse-title">
                 How do I create a Messenger bot?

                </span>
              </div>
              <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                <div class="card-body">
                 You’ll need an existing Facebook Page and administrator rights to manage it. After that click on the "Get Started Free" button at the top of the page.
       </br> </br>While you need a Facebook Page to get started, Your Codeonic bot is not restricted to just customers on your Facebook page. Anywhere your customers can click a link - your Website, in an email, on a QR code, etc,
       you can launch your Codeonic bot and start a conversation.</p>
                </div>
              </div>
            </div>
          </div>
          
        </div>
         <div class="row justify-content-center">
                <div class="col-lg-12 pt-40">
                    <div class="section-title text-center pb-20">
                        <h3 class="title">Try Codeonic for Free </h3>
                        <p class="text">Start building your bot, it is easy, fun, and proven to get results</p>
                        </br>
                        <a href="<?php echo base_url('home/login'); ?>" rel="nofollow" class="main-btn">GET STARTED FREE</a>
                    </div> <!-- section title -->
                </div>
            </div> <!-- row -->
      </div>
    </div>
  </div>
</section>

    <!--====== CONTACT PART ENDS ======-->
        
    
    <!--====== PART START ======-->
    
    <footer id="footer" class="footer-area">
        
        <div class="footer-shape shape-1"></div>
        <div class="footer-shape shape-2"></div>
        <div class="footer-shape shape-3"></div>
        <div class="footer-shape shape-4"></div>
        <div class="footer-shape shape-5"></div>
        <div class="footer-shape shape-6"></div>
        <div class="footer-shape shape-7"></div>
        <div class="footer-shape shape-8">
            <img class="svg" src="<?php echo base_url();?>assets/t3/assets/images/footer-shape.svg" alt="Shape">
        </div>
        
        <div class="footer-widget pt-30 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="footer-about mt-50 wow fadeIn" data-wow-duration="1.3s" data-wow-delay="0.2s">
                            <a class="logo" href="#" >
                               <a href="#"><img src="<?php echo base_url();?>assets/img/logo.png" alt="logo" style="max-height: 70px;"></a>
                            </a>
                            <p class="text">
							 <?php echo $this->lang->line("Our mission is to help businesses grow by building meaningful relationships with their customers"); ?></p>
                            <?php 
                                $facebook = $this->config->item('facebook');
                                $twitter  = $this->config->item('twitter');
                                $linkedin = $this->config->item('linkedin');
                                $youtube  = $this->config->item('youtube');

                                if($facebook=='' && $twitter=='' && $linkedin=='' && $youtube=='') $cls='hidden';
                            ?> <ul class="social <?php if(isset($cls)) echo $cls; ?>">
								 <li <?php if($facebook=='') echo "class='hidden'"; ?>>
                                	<a title="Facebook" target="https://www.facebook.com/Codeonic-Social-102152428369596" class="facebook" href="<?php echo $facebook; ?>"><i class="lni lni-facebook"></i>
                                	</a>
                                </li>
                                <li <?php if($twitter=='') echo "class='hidden'"; ?>>
                                	<a title="Twitter" target="_blank" class="twitter" href="<?php echo $twitter; ?>"><i class="lni lni-twitter"></i>
                                	</a>
                                </li>
                                <li <?php if($linkedin=='') echo "class='hidden'"; ?>>
                                	<a title="Linkedin" target="_blank" class="linkedin" href="<?php echo $linkedin; ?>"><i class="lni lni-linkedin"></i>
                                	</a>
                                </li>
                                <li <?php if($youtube=='') echo "class='hidden'"; ?>>
                                	<a title="Youtube" target="_blank" class="youtube" href="<?php echo $youtube; ?>"><i class="lni lni-youtube"></i>
                                	</a>
                                </li>
								
                            </ul>
                        </div> <!-- footer about -->
                    </div> 
                    <div class="col-lg-5 col-md-6">
                        <div class="footer-link d-flex flex-wrap">
                            <div class="footer-link-wrapper mt-45 wow fadeIn" data-wow-duration="1.3s" data-wow-delay="0.4s">
                                <div class="footer-title">
                                    <h4 class="title">QUICK LINK</h4>
                                </div>
                                <ul class="link">
                                    <li><a class="" href="#home">Home</a></li>
                                    <li><a class="" href="#features">Features</a></li>
                                    <li><a class="" href="#testimonial">Testimonial</a></li>
                                    <li><a class="" href="#service">Pricing</a></li>
                                    <li><a class="" href="#contact">Contact</a></li>
                                </ul>
                            </div> <!-- footer link wrapper -->
                            
                            <div class="footer-link-wrapper mt-45 wow fadeIn" data-wow-duration="1.3s" data-wow-delay="0.6s">
                                <div class="footer-title">
                                    <h4 class="title">SUPPORT</h4>
                                </div>
                                <ul class="link">
                                    	<li><a class="" href="#faq" ><?php echo $this->lang->line("FAQ"); ?></a></li>
                                    <li><a href="<?php echo base_url('home/terms_use'); ?>" target="_blank"><?php echo $this->lang->line("Terms of Service"); ?></a></li>
									<li><a href="<?php echo base_url('home/privacy_policy'); ?>" target="_blank"><?php echo $this->lang->line("Privacy Policy"); ?></a></li>
									<li>  <a href="<?php echo base_url('home/gdpr'); ?>" target="_blank"><?php echo $this->lang->line("GDPR Compliant"); ?></a></li>
									<li><a class="" href="#" target="_blank"><?php echo $this->lang->line("Media Agency"); ?></a></li>
                                </ul>
                            </div> <!-- footer link wrapper -->
                        </div> <!-- footer link -->
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="footer-contact mt-45 wow fadeIn" data-wow-duration="1.3s" data-wow-delay="0.8s">
                            <div class="footer-title">
                                <h4 class="title">Say Hello</h4>
                            </div>
                            <ul class="contact-list">
                                <li>
                                    <div class="contact-info d-flex">
                                        <div class="info-content media-body">
                                            <p class="text"><i class="lni lni-envelope"></i>  info@codeonic.com </p>
                                        </div>
                                    </div> <!-- contact info -->
                                </li>
                            </ul> <!-- contact list -->
                        </div> <!-- footer contact -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
        </div> <!-- footer widget -->
        
		
    </footer>
    
    <!--====== PART ENDS ======-->
    
    <!--====== BACK TOP TOP PART START ======-->

    <a href="#" class="back-to-top"><i class="lni lni-chevron-up"></i></a>

    <!--====== BACK TOP TOP PART ENDS ======-->
    
    <!--====== PART START ======-->
    
<!--
    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-lg-"></div> 
            </div>
        </div>
    </section>
-->
    
    <!--====== PART ENDS ======-->

      



    <!--====== Jquery js ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/vendor/jquery-1.12.4.min.js"></script>
    <script src="<?php echo base_url();?>assets/t3/assets/js/vendor/modernizr-3.7.1.min.js"></script>
    
    <!--====== Bootstrap js ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/popper.min.js"></script>
    <script src="<?php echo base_url();?>assets/t3/assets/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url();?>assets/t3/assets/js/slick.min.js"></script>
    
    <!--====== WOW js ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/wow.min.js"></script>
    <!--====== slidejs ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/swiper.min.js"></script>
    
    <!--====== Scrolling Nav js ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/jquery.easing.min.js"></script>
    <script src="<?php echo base_url();?>assets/t3/assets/js/scrolling-nav.js"></script>
    
    <!--====== Main js ======-->
    <script src="<?php echo base_url();?>assets/t3/assets/js/main.js"></script>
      <!-- cookiealert section -->

    <?php $this->load->view("include/fb_px"); ?> 
    <?php $this->load->view("include/google_code"); ?> 
</body>


<!-- Modal -->
<?php   
    $ct=0;
    foreach($customerReview as $singleReview) : 
        $ct++;
        $original = $singleReview[2];
        $base     = base_url();

        if (substr($original, 0, 4) != 'http') {
            $img = $base.$original;
        } else {
           $img = $original;
        }
?>

    <div id="myModal<?php echo $ct; ?>" class="modal fade" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" style="font-weight: bold; position: absolute"><?php echo $this->lang->line('Full Review'); ?></h4>
            </div>
            <div class="single-item" style="text-align: center; margin-top: 10px;">
                <div class="member-image">
                    <img class="img-circle img-thumbnail" src="<?php echo $img; ?>" alt="reviewer" style="width: 170px;border-radius: 50%;">
                </div>
                <div class="modal-body name-and-designation" style="margin-top: 10px;">
                    <h4><?php echo $singleReview[0]; ?></h4>
                    <p><?php echo $singleReview[1]; ?></p>
                    <p style="text-align: justify; font-style: normal; color: #000;padding:10px 20px;"><?php echo $singleReview[3]; ?></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo $this->lang->line('Close'); ?></button>
            </div>
        </div>

      </div>
    </div>
<?php endforeach; ?>
<!-- End of Modal -->

<style>
.price-plan1	{
    background: rgb(0,222,192);
    background: linear-gradient(200deg, rgba(0,222,192,1) 0%, rgba(2,254,212,1) 41%, rgba(0,201,180,1) 72%, rgba(0,94,111,1) 100%);
    border-radius: 20px;
}
.price-plan2	{
    background: rgb(198,109,155);
	background: linear-gradient(200deg, rgba(198,109,155,1) 0%, rgba(238,116,151,1) 41%, rgba(142,100,161,1) 72%, rgba(28,85,170,1) 100%);
	border-radius: 20px;
}
.price-plan3	{
    background: rgb(255,111,150);
	background: linear-gradient(200deg, rgba(255,111,150,1) 0%, rgba(255,188,123,1) 41%, rgba(255,159,134,1) 72%, rgba(255,111,150,1) 100%);
	border-radius: 20px;
}
.single-pricing .pricing-title .title, .single-pricing .pricing-price .price{
    text-transform: uppercase;
    font-weight: 700;
    color: #fff;font-size: 2em;
}
.single-pricing .pricing-price .text {
    text-transform: uppercase;
    color: #fff;
}
.single-pricing .pricing-list{
    color: #fff;
    text-align: left;
	margin-top: 110px;
}
.single-pricing .main-btn.main-btn-2, .single-pricing .main-btn {
    color: #ffffff;
    border-color: #ffffff;
    border-radius: 50px;
    text-transform: uppercase;
}
.single-pricing .pricing-price {
    margin-top: 30px;
    background: #fff;
    float: left;
    display: block;
    position: absolute;
    width: 60%;
    left: 0;
    border-radius: 0 100px 100px 0;
    -webkit-box-shadow: 0 0 11px 0 rgba(154,154,154,.16);
    -moz-box-shadow: 0 0 11px 0 rgba(154,154,154,.16);
    box-shadow: 0px 11px 7px 0px rgba(154,154,154,.16);
    clear: both;
}
.single-pricing.pricing-active.price-plan1 .price, .single-pricing.pricing-active.price-plan1 .pricing-price .text {
    color: #01ebc8;
}
.single-pricing.pricing-active.price-plan2 .price, .single-pricing.pricing-active.price-plan2 .pricing-price .text {
    color: #c66c99;
}
.single-pricing.pricing-active.price-plan3 .price, .single-pricing.pricing-active.price-plan3 .pricing-price .text {
   color: #fb7293;
}
.single-pricing.pricing-active .pricing-price .text {
    font-size: 9px;
    margin-top: 10px;
	}
	.single-pricing .pricing-list .list li {
    text-transform: uppercase;
}
.single-pricing .pricing-list .list li p {
	font-size: 9px;
	margin-left: 20px;
    line-height: 12px;
    margin-top: -8px;
	color: #ffffff;
}
.single-pricing.pricing-active {
    -webkit-box-shadow: 10px 11px 10px 0px rgba(66, 66, 66, 0.16);
    -moz-box-shadow: 10px 11px 10px 0px rgba(66, 66, 66, 0.16);
    box-shadow: 10px 11px 10px 0px rgba(66, 66, 66, 0.16);
}
.single-pricing.pricing-active .pricing-price .price {
    font-size: 2.5em;
}
.single-services .services-content .services-title a {
text-transform: uppercase;}

.header-app{
    width: 100%;
    height: 100%;
    max-width: 350px;
    margin-top: 61px;
}
.tab-content>.active{
    display:block;
}
.tab-pane.active{display:block}
.tab-pane{display:none;}
.single-features {    padding: 20px;
cursor: pointer;}

.header-image {
    position: relative;
    display: inline-block;
    text-align: center;
    margin-left: 50px;
    padding-top: 100px;
    padding-bottom: 100px;
}

.header-image .app {
    position: relative;
    -webkit-transform: rotate(-25deg) translateY(-15%);
    -moz-transform: rotate(-25deg) translateY(-15%);
    -ms-transform: rotate(-25deg) translateY(-15%);
    -o-transform: rotate(-25deg) translateY(-15%);
    transform: rotate(25deg) translateY(-35%);
    max-width: 280px;
    top: 170px;
    left: -130px;
    -webkit-box-shadow: -15px 10px 30px 0 rgba(0,0,0,.3);
    -moz-box-shadow: -15px 10px 30px 0 rgba(0,0,0,.3);
    box-shadow: -15px 10px 30px 0 rgba(0,0,0,.3);
    border-radius: 33px;
}
.about-image .app {
    border-radius: 35px;
}
.features-image .image{

	    -webkit-box-shadow: none;
    -moz-box-shadow: none;
    box-shadow: none;
border-radius: 50px;}
#shape {
    position: absolute;
	    width: 100%;
}
#shape .shape-1 {
    background: -webkit-linear-gradient(#fe8464 0%,#fe6e9a 100%);
    background: -o-linear-gradient(#fe8464 0%,#fe6e9a 100%);
    background: linear-gradient(#fe8464 0%,#fe6e9a 100%);
    width: 75px;
    height: 75px;
    border-radius: 50%;
    left: 70px;
    opacity: .55;position: relative;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-2 {
    background: -webkit-linear-gradient(#33c8c1 0%,#119bd2 100%);
    background: -o-linear-gradient(#33c8c1 0%,#119bd2 100%);
    background: linear-gradient(#33c8c1 0%,#119bd2 100%);
    width: 39px;
    height: 39px;
    border-radius: 50%;
    bottom: 40px;
    left: 40%;
    opacity: .55;position: relative;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-3 {
    background: -webkit-linear-gradient(#361cc1 0%,#2e82ef 100%);
    background: -o-linear-gradient(#361cc1 0%,#2e82ef 100%);
    background: linear-gradient(#361cc1 0%,#2e82ef 100%);
    width: 20px;
    height: 20px;
    border-radius: 50%;
    left: 35%;
    top: 40px;position: relative;
    opacity: .55;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-4 {
    background-color: #eba31a;
    width: 15px;
    height: 15px;
    border-radius: 50%;
    left: 50%;
    bottom: 5px;
    -webkit-transform: translateX(-50%);
    -moz-transform: translateX(-50%);
    -ms-transform: translateX(-50%);
    -o-transform: translateX(-50%);
    transform: translateX(-50%);
    opacity: .55;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-5 {
    background-color: #e29e19;
    right: 37%;
    top: 0;
    width: 39px;position: relative;
    height: 39px;
    border-radius: 50%;
    opacity: .55;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-6 {
    background-color: #b60d81;
    width: 15px;
    height: 15px;
    border-radius: 50%;
    top: 125px;
    right: 15%;position: relative;
    opacity: .55;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-7 {
    background-color: #6c63ff;
    width: 64px;
    height: 64px;
    bottom: 25px;
    right: 8%;position: relative;
    opacity: .55;
    border-radius: 50%;
    -webkit-animation: animation1 2s linear infinite;
    -moz-animation: animation1 2s linear infinite;
    -o-animation: animation1 2s linear infinite;
    animation: animation1 2s linear infinite;
}
#shape .shape-8 {
    top: 30px;
    right: -45px;position: relative;
}
.hidden{display:none}
.header-hero-content .header-title {
    font-size: 4em;
}
@media (max-width: 767px){
.header-image .app {
    -webkit-transform: none;
    -moz-transform: none;
    -ms-transform: none;
    -o-transform: none;
    transform: none;
        top: 0px;
       left: 5%;
}
.about-image .app {
    max-width: 175px;
    border-radius: 25px;
    top: 85px;
    left: 26%;
    transform: none;
}
 .header-image {
         margin: 0 auto;
 }
 .about-image {
    width: 100%;
}
}
 .single-features:hover,  .single-features.active {
    border-left: 5px solid #007bff;
}


.post-details{
    background: #fff;
    -webkit-border-radius: 4px;
    border-radius: 4px;
    -webkit-box-shadow: 0 2px 4px rgba(108, 111, 115, 0.1);
    box-shadow: 0 2px 4px rgba(108, 111, 115, 0.1);
    margin-bottom: 30px;
    
}
.blog-meta-wrap, .post-details .title{
   
    padding-left: 30px;
    padding-right: 30px;
}
.post-content, .sidebar--blog .sidebar-card{
    border-bottom: 1px solid #ececec;
    padding-bottom: 10px;
    padding-left: 30px;
    padding-right: 30px;
}
.collapse-icon [data-toggle=collapse]:before {
    display: inline-block;
    font: normal normal normal 1em/1 "LineIcons";
    speak: none;
    text-transform: none;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    content: "\ea58";
}
.collapse-icon [data-toggle=collapse]:after {
    display: inline-block;
    font: normal normal normal 1em/1 "LineIcons";
    speak: none;
    text-transform: none;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    content: "\ea5e";
}

.collapse-margin:hover{   
 -webkit-box-shadow: 0 8px 16px 10px rgba(0,0,0,.08);
    box-shadow: 0 8px 16px 10px rgba(0,0,0,.08);
    -webkit-transform: translate3d(0,-4px,0);
    transform: translate3d(0,-4px,0);

}
.collapse-margin{
    background: #fff;
-webkit-box-shadow: 0 4px 8px 0 rgba(0,0,0,.08);
    box-shadow: 0 4px 8px 0 rgba(0,0,0,.08);
    -webkit-transition: -webkit-transform .3s ease,-webkit-box-shadow .3s ease;
    transition: -webkit-transform .3s ease,-webkit-box-shadow .3s ease;
    transition: transform .3s ease,box-shadow .3s ease;
    transition: transform .3s ease,box-shadow .3s ease,-webkit-transform .3s ease,-webkit-box-shadow .3s ease;
    -webkit-transform: translateZ(0);
    transform: translateZ(0);
    }
   .collapse-margin .card-header{
    border-bottom: 0;
}
</style>
</html>
