<?php $this->load->view('admin/theme/message'); ?>
<style type="text/css">
    .button{
        margin-top: 10px;
    }
    .datagrid-body
    {
      overflow: hidden !important; 
    }

    .emojionearea, .emojionearea.form-control
    {
        height: 150px !important;
    }


</style>

<div id="dynamic_field_modal" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" id="page_name">
                <div class="modal-body" style="padding-bottom:0">
                    <div class="row">
                          <div class="col-12"> 
                                <div class="form-group">
                                  <label><?php echo $this->lang->line("Please select a page"); ?></label>
                                  <?php 
                                  $page_list[''] = $this->lang->line("Choose a Page");
                                  echo form_dropdown('page_table_id',$page_list,'','id="page_table_id" class="form-control select2" style="width:100%;"'); 
                                  ?>
                              </div>       
                          </div>
                    </div>
                </div>
                <div class="modal-footer" style="margin-top: 10px;">
                    <button class="btn btn-lg btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> <?php echo $this->lang->line("Cancel"); ?></button>
                    <button id="submit" class="btn btn-primary btn-lg"><i class="fas fa-check"></i> <?php echo $this->lang->line('Ok'); ?></button>
                    
                </div>
            </form>
        </div>
    </div>

</div> 

<section class="section section_custom">
    <div class="section-header">
        <h1><i class="fa fa-th-large"></i> <?php echo $page_title; ?></h1>
        <div class="section-header-button">
         <a class="btn btn-primary" name="add" id="add"  href="#">
            <i class="fas fa-plus-circle"></i> <?php echo $this->lang->line("Create new Flow"); ?>
         </a> 
        </div>
        <div class="section-header-breadcrumb">
          <div class="breadcrumb-item"><?php echo $this->lang->line("Visual Flow Builder"); ?></div>
          <div class="breadcrumb-item"><?php echo $page_title; ?></div>
        </div>
    </div>

    <div class="section-body">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-body data-card">
                <div class="table-responsive">
                  <table class="table table-bordered" id="mytable">
                    <thead>
                      <tr>
                        <th>#</th>      
                        <th><?php echo $this->lang->line("Template ID"); ?></th>      
                        <th><?php echo $this->lang->line("Reference Name"); ?></th>
                        <th><?php echo $this->lang->line("Page Name"); ?></th>
                        <th style="min-width: 150px"><?php echo $this->lang->line("Actions"); ?></th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>             
              </div>

            </div>
          </div>
        </div>
    </div>
</section>  

<script>
$(document).ready(function(){

    var base_url="<?php echo base_url(); ?>";
    var page_auto_id = "<?php echo $page_auto_id; ?>";
    if(page_auto_id != 0)
      var data_url = base_url+'visual_flow_builder/visual_flow_builder_data/'+page_auto_id;
    else
      var data_url = base_url+'visual_flow_builder/visual_flow_builder_data';

    // datatable section started
    var table = $("#mytable").DataTable({
        serverSide: true,
        processing:true,
        bFilter: true,
        order: [[ 1, "desc" ]],
        pageLength: 10,
        ajax: 
        {
            "url": data_url,
            "type": 'POST',
            "dataSrc": function ( json ) 
            {
              $(".table-responsive").niceScroll();
              return json.data;
            } 
        },
        language: 
        {
          url: "<?php echo base_url('assets/modules/datatables/language/'.$this->language.'.json'); ?>"
        },
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        columnDefs: [
            {
              targets: [1],
              visible: false
            },
            {
              targets: '',
              className: 'text-center',
              sortable: false
            },
            {
                targets: [4],
                "render": function ( data, type, row, meta ) 
                {
                    var id = row[1];
                    var edit_str="<?php echo $this->lang->line('Edit');?>";
                    var delete_str="<?php echo $this->lang->line('Delete');?>";
                    var str="";   
                    str="&nbsp;<a class='text-center edit_reply_info btn btn-circle btn-outline-warning edit' href='#' name='edit' title='"+edit_str+"' table_id='"+id+"'>"+'<i class="fa fa-edit"></i>'+"</a>";
                    str=str+"&nbsp;<a name='delete' href='#' class='text-center delete_data btn btn-circle btn-outline-danger ' title='"+delete_str+"' table_id="+id+" '>"+'<i class="fa fa-trash"></i>'+"</a>";
                  
                    return str;
                }
            }
        ]
    });
    // End of datatable section

    $('#add').click(function(e){
        e.preventDefault();
        $('#dynamic_field_modal').modal('show');
    });

    $('#submit').click(function(e) {
        e.preventDefault();
       var page_table_id = $('#page_table_id').val();
       if(page_table_id == '')
       {
          swal('<?php echo $this->lang->line("Warning"); ?>', '<?php echo $this->lang->line("You have to select a page"); ?>', 'warning');
          return false;
       }
       else
       {
          var link = base_url + "visual_flow_builder/load_builder/" + page_table_id + "/1";
          window.location.replace(link);
       }

    });

    $(document).on('click', '.edit_reply_info', function(event) {
      event.preventDefault();
      var table_id = $(this).attr('table_id');
      var link = base_url + "visual_flow_builder/edit_builder_data/" + table_id + "/1";
      window.location.replace(link);
    });


    $(document).on('click', '.delete_data', function(event) {
        event.preventDefault();
        swal({
            title: '<?php echo $this->lang->line("Warning"); ?>',
            text: '<?php echo $this->lang->line("Are you sure you want to delete this campaign"); ?>',
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        })
        .then((willreset) => {
            if (willreset) 
            {
                $(this).addClass('btn-progress');
                var table_id = $(this).attr('table_id');

                $.ajax({
                    context: this,
                    type:'POST',
                    url: base_url + "visual_flow_builder/delete_flowbuilder_data",
                    dataType: 'json',
                    data: {table_id},
                    success:function(response){ 
                    if(response.status == 1)
                    {
                        $(this).removeClass('btn-progress');
                        
                        swal('<?php echo $this->lang->line("Success"); ?>', response.message, 'success').then((value) => {
                          table.draw();
                      });
                    }
                    else
                    {
                        swal('<?php echo $this->lang->line("Error"); ?>', response.message, 'error');
                    }
                },
                error:function(response){
                    var span = document.createElement("span");
                    span.innerHTML = response.responseText;
                    swal({ title:'<?php echo $this->lang->line("Error!"); ?>', content:span,icon:'error'});
                }
            });
            } 
        });
    });
     

});
</script>