<style>
	#local_container.error {
		border: solid red;
	}

	#local_container.success {
		border: solid green;
	}

	.table-responsive2 {
		overflow-x: hidden;
	}
	
    .swal2-content {
        z-index: 10!important;
    }
    
    #myFlows_filter label {
        float:right !important;
    }
    
    .tabs {
        margin-bottom: 10px;
    }
    
    .tab-item .fas, .tab-item .far {
        font-size: 110%;
    }
    
    .tab-item {
        display: inline;
        padding: 10px;
        background: #FAFDFB;
        font-size: 150%;
        width: 250px;
        color: darkslategray;
        border: none;
        position: relative;
        margin-bottom: 30px;
    }
    
    .tab-item.selected {
        background: white;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.03);
        border-radius: 3px;        
    }
    
    .template-item img {
        max-width: 150px;
        display: inline;
        margin: auto;        
    }

    .stars .fas {
        color: #FFD15C;
        font-size: 120%;
        margin: 0px 10px;
    }
    
    .admin_action_container {
        position: absolute;
        right: 0px;
        text-align: center;
    }
    
    .editTemplate, .deleteTemplate {
        width: 30px;
        padding: 0px;
        display: inline;
        margin-right: 5px;
       
    }
    
    .dropzone {
        border-radius: 5px;
        border: 2px dashed gray;
        border-image: none;
        margin-left: auto;
        margin-right: auto;
        height: 250px;
        padding: 0px;
        background-color: #8080801a;
        position: relative;
    }
    
    .dropzone:hover {
        border: 2px dashed rgb(0, 135, 247);
    }
    
    .upload_img_icon {
        width:50px;
    }
    
    #img_icon, #vid_icon, #file_icon {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 50px;
        transform: translate(-50%, -50%);
        z-index: -1;
        opacity: 40%;
    }        

    #item_image, #item_video, #item_file {
        display: flex;
        width: 50%;
        position: absolute;
        top: 30%;
        left: 50%;
        transform: translate(-50%, -50%);          
    }    

    .uploaded_img {
        padding: 0px !important;
        height: 100% !important;            
    }

</style>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/please-wait/0.0.5/please-wait.min.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.25.0/slimselect.css" />
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script>
    var CurrentUserID = <?php echo $user_id; ?>;
    var CurrentUserEmail = "<?php echo $user_email; ?>";
    var CurrentUserType = "<?php echo $user_type; ?>";
    var NeedUpdate = "<?php echo $need_update; ?>";
    var CurrentSiteUrl = "<?php echo $site_url; ?>";
</script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script src="https://www.jqueryscript.net/demo/Minimal-AJAX-Loading-Spinner-Plugin-with-jQuery-pleaseWait/jquery.pleaseWait.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.25.0/slimselect.min.js"></script>
<section class="section">
	<div class="section-header">
		<h1><i class="fas fa-project-diagram"></i> <?php echo $this->lang->line('Flow Builder'); ?></h1>
		<div class="section-header-breadcrumb">
			<div class="breadcrumb-item"><a href="<?php echo base_url('flow_builder'); ?>"><?php echo $this->lang->line('Flow Builder'); ?></a></div>
		</div>
	</div>
</section>
<section class="section section_custom">
	<div class="section-body">
		<div class="row">
			<div class="col-12">
				<div class="tabs">
                    <div data-id="flow_list" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('List Of My Flows'); ?>" class="tab-item selected pr-3 pl-3"><i class="fas fa-list"></i> <?php echo $this->lang->line('Flow List'); ?></div>
				    <div data-id="templates" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('You can use Pre-Built templates'); ?>" class="tab-item pr-3 pl-3"><i class="fas fa-paste"></i> <?php echo $this->lang->line('Templates'); ?></div>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="section section_custom">
	<div class="section-body" id="results">
		<div class="row">
			<div class="col-12">
				<div class="card main_card">
					<div class="card-body">
					    <div data-id="flow_list" class="tab-containers flow_list onscreen">
					        <button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('Create A New Flow'); ?>" class="create_new_flow btn btn-success mb-3"> <?php echo $this->lang->line('Create New Flow'); ?></button>
    						<div class="table-responsive2">
    							<table class="table table-striped table-bordered" id="myFlows"></table>
    						</div>					        
					    </div>
                        <div data-id="templates" class="tab-containers templates" style="display:none; margin: auto;">
				            <div class="row d-flex justify-content-center">
				                <div class="col-12 text-center m-5"><h3><span class="stars"><i class="fas fa-star"></i></span> <?php echo $this->lang->line('Featured Templates'); ?> <span class="stars"><i class="fas fa-star"></i></span></h3></div>
				            <?php
				                $template_output = "";
				                $cta = $this->lang->line('USE THIS TEMPLATE');
				                $edit = $this->lang->line("Change Template Image");
				                $delete = $this->lang->line("Delete This Template");
				                foreach($template_data as $data){
    				                $name = urldecode($this->lang->line($data['name']));
    				                $img = $data['img'];
    				                $id = $data['id'];
    				                if($user_type == 'Admin'){
    				                    $admin_control = "<button img-url='$img' template-name='$name' data-type='template' data-toggle=\"tooltip\" data-placement=\"top\" title=\"$edit\" data-id=\"$id\" class=\"btn btn-md btn-primary editTemplate\"><i class=\"fas fa-edit\"></i></button>";
    				                    $admin_control .= "<button data-toggle=\"tooltip\" data-placement=\"top\" title=\"$delete\" data-id=\"$id\" class=\"btn btn-md btn-danger deleteTemplate\"><i class=\"fas fa-trash-alt\"></i></button>";
    				                }else{
    				                    $admin_control = "";
    				                }
    				                $template_output .=
    				                "<div id='template_$id' class=\"col-3 template-item d-flex justify-content-center text-center\">
                                        <div class=\"card\">
                                            <div class='admin_action_container'>$admin_control</div>
                                            <img src=\"$img\">
                                            <div class=\"card-body\">
                                                <h5 class=\"card-title\">$name</h5>
                                                <a href=\"\" data-id=\"$id\" class=\"btn btn-primary\">$cta</a>
                                            </div>
                                        </div>
    				                </div>";
				                }
				                
				                echo $template_output;
				            ?>
				            </div>
					    </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<script>

    $(document).ready(() => {
        
        TriggerTable();
        
        (async ()=>{
            const MyPages = await ext_get_user_pages_ajax( CurrentUserID );
            $('.create_new_flow').on('click', () => {
                (async () => {
                    let timerInterval;
                    Swal.fire({
                        title: "<?php echo $this->lang->line('Preparing....'); ?>",
                        html: "<?php echo $this->lang->line('Please wait...'); ?>",
                        timer: 30000,
                        timerProgressBar: true,
                        onBeforeOpen: () => {
                            Swal.showLoading();
                            timerInterval = setInterval(() => {
                                const content = Swal.getContent()
                                    if (content) {
                                const b = content.querySelector('b')
                                    if (b) {
                                        b.textContent = Swal.getTimerLeft()
                                    }
                                }
                            }, 100)
                        },
                        onClose: () => {
                            clearInterval(timerInterval)
                        }
                    });
                    let result = await ext_check_usage(777);
                    if(result.status == 0){
                        swal.fire({
                            title: result.notice,
                            text: "<?php echo $this->lang->line("Please upgrade your account to do more."); ?>",
                            icon: "error",
                            showCancelButton: true,
                            confirmButtonText: "<?php echo $this->lang->line("UPGRADE NOW"); ?>",
                        }).then((result)=>{
                            if(result.value){
                                window.location.href = CurrentSiteUrl+ "payment/buy_package";
                            }
                        });
                        return false;
                    }
                    var html = '<p><?php echo $this->lang->line("Enter Your New Flow\'s Name:"); ?></p><input type="text" id="myFlow_name" class="swal2-input"><p><?php echo $this->lang->line("Select Your New Flow\'s Page:"); ?></p><select class="swal2-select myPages" style="display: flex;"><option value="" disabled=""><?php echo $this->lang->line("Select Page"); ?></option></select>';
                    Swal.fire({
                        title: "<?php echo $this->lang->line('Configure Flow'); ?>",
                        html: html,
                        showCancelButton: true,
                        focusConfirm: false,
                        onOpen: () => {
                            $.each(MyPages, (k,v) => {
                                $('.myPages').append($(`<option value="${v.page_id}">${v.page_name}</option>`));   
                            })
                            
                            var SSselect = new SlimSelect({
                              select: '.myPages'
                            })
                            
                        },
                        preConfirm: () => {
                            
                            if(!$('.myPages').val() || !$("#myFlow_name").val() ){
                                Swal.showValidationMessage(`Error: Values are missing`)
                            }else{
                                return { name: $("#myFlow_name").val(), page_id: $('.myPages').val() };
                            }
                            
                        }
                    }).then((result) => {
                        if(result.value){
                            var page_id = result.value.page_id;
                            var name = encodeURIComponent(result.value.name);
                            window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name;
                        }
                    })                    
                })()
            });
        })();
        
        var Before = 0;
        var ControlsDisabled = false;
        $('.tab-item').on('click',function(){
        
            if(ControlsDisabled == true){
                return false;
            }
        
            ControlsDisabled == true;
        
            var After = $(this).index();
            
            $('.tab-item').removeClass('selected');
            $(this).addClass('selected');
            
            var selected = $(this).attr('data-id');
            var current = $('.onscreen').attr('data-id');
            
            if(Before == After){
                return false;
            }
            
            if(selected == current){
                return false;
            }
            
            if(Before > After){
                $('.'+current).toggle( "slide", {direction: "right"}, function(){
                    $('.'+current).removeClass('onscreen');
                    $('.'+selected).toggle("slide",{direction: "left"}, function(){
                        ControlsDisabled == false;
                    });
                    $('.'+selected).addClass('onscreen');
                });
            }else{
                $('.'+current).toggle( "slide", {direction: "left"}, function(){
                    $('.'+current).removeClass('onscreen');
                    $('.'+selected).toggle("slide",{direction: "right"}, function(){
                        ControlsDisabled == false;
                    });
                    $('.'+selected).addClass('onscreen');
                });
            }
        
            Before = After;
        
        });
        
        $('.template-item a').on('click', function(e){
            e.preventDefault();
            (async () => {
                let timerInterval;
                Swal.fire({
                    title: "<?php echo $this->lang->line('Preparing....'); ?>",
                    html: "<?php echo $this->lang->line('Please wait...'); ?>",
                    timer: 30000,
                    timerProgressBar: true,
                    onBeforeOpen: () => {
                        Swal.showLoading();
                        timerInterval = setInterval(() => {
                            const content = Swal.getContent()
                                if (content) {
                            const b = content.querySelector('b')
                                if (b) {
                                    b.textContent = Swal.getTimerLeft()
                                }
                            }
                        }, 100)
                    },
                    onClose: () => {
                        clearInterval(timerInterval)
                    }
                });                
                let result = await ext_check_usage(778);
                if(result.status == 0){
                    swal.fire({
                        title: result.notice,
                        text: "<?php echo $this->lang->line("Please upgrade your account to do more."); ?>",
                        icon: "error",
                        showCancelButton: true,
                        confirmButtonText: "<?php echo $this->lang->line("UPGRADE NOW"); ?>",
                    }).then((result)=>{
                        if(result.value){
                            window.location.href = CurrentSiteUrl+ "payment/buy_package";
                        }
                    });
                    return false;
                }
                
                var type = $(this).attr('data-id');
                var data_type = $(this).attr('data-type');
                if(type){
                    
                    if(typeof data_type != 'undefined' && data_type == 'template'){
                        var templateName = $(this).attr('template-name');
                        var myTitle = "<?php echo $this->lang->line('You Are Editing This Template'); ?>";
                        var html = '<p><?php echo $this->lang->line("You Can Change Your Template Name Below:"); ?></p><input type="text" id="myFlow_name" class="swal2-input" value="'+templateName+'"><div id="PageWrapper" style="display: none;"><p><?php echo $this->lang->line("Select Your Template Flow\'s Testing Page:"); ?> </p><select class="swal2-select myPages" style="display: flex;"><option value="" disabled=""><?php echo $this->lang->line("Select Page"); ?></option></select></div>';
                    }else{
                        var myTitle = "<?php echo $this->lang->line('Configure Templated Flow'); ?>";
                        var html = '<p><?php echo $this->lang->line("Enter Your Templated Flow\'s Name:"); ?></p><input type="text" id="myFlow_name" class="swal2-input"><div id="PageWrapper" style="display: none;"><p><?php echo $this->lang->line("Select Your New Flow\'s Page:"); ?> </p><select class="swal2-select myPages" style="display: flex;"><option value="" disabled=""><?php echo $this->lang->line("Select Page"); ?></option></select></div>';
                    }
                    
                    Swal.fire({
                        title: myTitle,
                        html: html,
                        showCancelButton: true,
                        focusConfirm: false,
                        onOpen: () => {
                            (async ()=>{
                                swal.showLoading();
                                const MyPages3 = await ext_get_user_pages_ajax( CurrentUserID );
                                $.each(MyPages3, (k,v) => {
                                    $('.myPages').append($(`<option value="${v.page_id}">${v.page_name}</option>`));   
                                })
                                
                                var SSselect = new SlimSelect({
                                  select: '.myPages'
                                })
                                
                                $('#PageWrapper').fadeIn('slow');
                                swal.hideLoading();
                            })()    
                            
                        },
                        preConfirm: () => {
                            
                            if(!$('.myPages').val() || !$("#myFlow_name").val() ){
                                Swal.showValidationMessage(`Error: Values are missing`)
                            }else{
                                return { name: $("#myFlow_name").val(), page_id: $('.myPages').val() };
                            }
                            
                        }
                    }).then((result) => {
                        if(result.value){
                            var page_id = result.value.page_id;
                            var name = encodeURIComponent(result.value.name);
                            if(typeof data_type != 'undefined' && data_type == 'template'){
                                window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&template="+type+"&action=create_template";
                            }else{
                                window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&template="+type;    
                            }
                        }
                    })
                }else{
                    swal.fire("<?php echo $this->lang->line("Coming Soon!"); ?>", "<?php echo $this->lang->line("This template is not yet available."); ?>", "info");
                }
                
            })()
        })
        
        ext_check_update();
        
		$('.deleteTemplate').on('click', function(){
		    var post_id = $(this).attr('data-id');
            Swal.fire({
                title: "<?php echo $this->lang->line('Are You Sure You Want To Delete This Template?'); ?>",
                showCancelButton: true,
                focusConfirm: false,
                icon: 'error',
            }).then((result) => {
                if(result.value){
                    ext_delete_template_ajax(post_id);
                }
            })				    
		})
		
		$('.editTemplate').on('click', function(){
		    var post_id = $(this).attr('data-id');
		    var template_image_url = $(this).attr('img-url');
		    EditTemplateImage(post_id, template_image_url);
		})

    });

    function ext_get_user_flows_ajax( user_id_raw ){
        
        return new Promise((resolve,reject)=>{
            var domain = CurrentSiteUrl+ "flow_builder/ext_get_user_flows";
            $.ajax({
                type: "POST",
                url: domain,
                timeout: 5000,
                data: {
                    user_id   : user_id_raw,
                },
                success:function( result ) {
                    var UserFlows = JSON.parse(result);
                    console.log(UserFlows);
                    resolve(UserFlows);
                },
                error: function(errorThrown){
                    swal.fire("<?php echo $this->lang->line('Failed To Send Test!'); ?>", "<?php echo $this->lang->line('Please try again...'); ?>", "error");
                }
            });            
        })

    };
    
    function ext_get_user_pages_ajax( user_id_raw ){
        
        return new Promise((resolve,reject)=>{
            var domain = CurrentSiteUrl+ "flow_builder/ext_get_user_pages_flow_builder";
            $.ajax({
                type: "POST",
                url: domain,
                timeout: 5000,
                data: {
                    user_id   : user_id_raw,
                },
                success:function( result ) {
                    var UserPages = JSON.parse(result);
                    console.log(UserPages);
                    resolve(UserPages);
                },
                error: function(errorThrown){
                    swal.fire("<?php echo $this->lang->line("Failed To Get User Pages!"); ?>", "<?php echo $this->lang->line('Please try again...'); ?>", "error");
                }
            });          
        })

    };    
    
	const Toast = Swal.mixin({
		toast: true,
		position: 'top-end',
		showConfirmButton: false,
		timer: 1000,
		timerProgressBar: true,
		onOpen: (toast) => {
			toast.addEventListener('mouseenter', Swal.stopTimer)
			toast.addEventListener('mouseleave', Swal.resumeTimer)
		}
	})

	async function TriggerTable(){
		var Data = [], SheetsData = [];
		console.log("TRIGGERED: TriggerTable()");
		
		const JSON_result = await ext_get_user_flows_ajax( CurrentUserID );
        console.log(JSON_result)
		$.each(JSON_result, function(a, v) {
		    var post_id = v.id;
		    var flowName = decodeURIComponent(v.name);
            if(typeof v.template_id != 'undefined' && v.template_id != "" && v.template_id != null){
                var name = '<span id="flow_title_'+ post_id +'"> [<i style="color:#FFD700" class="fas fa-trophy"></i> TEMPLATE <i style="color:#FFD700" class="fas fa-trophy"></i>] | ' + flowName + '</span>';
            }else{
                var name = '<span id="flow_title_'+ post_id +'">' + flowName + '</span>';
            }
            
            if(flowName.includes("SHARED FLOW:")){
                var action = '<button data-type="is_template" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Edit This Flow"); ?>" flow-name="'+v.name+'" page-id="'+v.fb_page_id+'" data-id="' + v.id + '" class="btn btn-md btn-primary edit mr-2"><i class="fas fa-edit"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Delete This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-danger removeMe mr-2"><i class="fas fa-trash-alt"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Duplicate This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-info cloneMe mr-2"><i class="fas fa-clone"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Share This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-success shareMe mr-2"><i class="fas fa-share-square"></i></button>';                
            }else{
                var action = '<button data-type="" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Edit This Flow"); ?>" flow-name="'+v.name+'" page-id="'+v.fb_page_id+'" data-id="' + v.id + '" class="btn btn-md btn-primary edit mr-2"><i class="fas fa-edit"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Delete This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-danger removeMe mr-2"><i class="fas fa-trash-alt"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Duplicate This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-info cloneMe mr-2"><i class="fas fa-clone"></i></button><button data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line("Share This Flow"); ?>" data-id="' + v.id + '" class="btn btn-md btn-success shareMe mr-2"><i class="fas fa-share-square"></i></button>';    
            }
<?php
	if($user_type == 'Admin'){
	    $cta = $this->lang->line("Promote To Template");
	    echo "if(v.template_id == '' || v.template_id == null){";
        echo "action +=\"<button data-toggle='tooltip' data-placement='top' title='$cta' data-id='\" + v.id + \"' class='btn btn-md btn-warning promoteMe mr-2'><i class='fas fa-trophy'></i></button>\";";
	    echo "}";
	}
?>
            var page_name = v.page_name;   
			var date_created = v.created_at;
			Data.push([(a+1), post_id, name, page_name, date_created, action]);
		});

		$('#myFlows').DataTable({
			data: Data,
            "columns": [
                { title: "<?php echo $this->lang->line("Index"); ?>" },
                { title: "<?php echo $this->lang->line("Post ID"); ?>" },
                { title: "<?php echo $this->lang->line("Name"); ?>" },
                { title: "<?php echo $this->lang->line("Page"); ?>" },
                { title: "<?php echo $this->lang->line("Date Created"); ?>" },
                { title: "<?php echo $this->lang->line("Actions"); ?>" },
            ],
			fnDrawCallback: function() {
			    
				$('.edit').on('click', function() {
                    var post_id = $(this).attr('data-id');
                    var page_id = $(this).attr('page-id');
                    var is_template = $(this).attr('data-type');
                    var name = encodeURIComponent($(this).attr('flow-name'));
                    if(!page_id){
                        var html = '<p><?php echo $this->lang->line("Enter Your New Flow\'s Name:"); ?></p><input type="text" id="myFlow_name" class="swal2-input"><div class="pageWrapper" style="display:none"><p><?php echo $this->lang->line("Select Your New Flow\'s Page:"); ?></p><select class="swal2-select myPages" style="display: flex;"><option value="" disabled=""><?php echo $this->lang->line("Select Page"); ?></option></select></div>';
                        Swal.fire({
                            title: "<?php echo $this->lang->line('Configure Flow'); ?>",
                            html: html,
                            showCancelButton: true,
                            focusConfirm: false,
                            onOpen: () => {
                                (async ()=>{
                                    Swal.showLoading();
                                    const MyPages2 = await ext_get_user_pages_ajax( CurrentUserID );
                                    Swal.hideLoading();
                                    $(".pageWrapper").fadeIn('slow');
                                    $.each(MyPages2, (k,v) => {
                                        $('.myPages').append($(`<option value="${v.page_id}">${v.page_name}</option>`));   
                                    })
                                    
                                    var SSselect = new SlimSelect({
                                      select: '.myPages'
                                    })
                                    
                                    $('#MyPagesWrapper').fadeIn('slow');
                                    
                                })()
                                
                            },
                            preConfirm: () => {
                                
                                if(!$('.myPages').val() || !$("#myFlow_name").val() ){
                                    Swal.showValidationMessage(`Error: Values are missing`)
                                }else{
                                    return { name: $("#myFlow_name").val(), page_id: $('.myPages').val() };
                                }
                                
                            }
                        }).then((result) => {
                            if(result.value){
                                var page_id = result.value.page_id;
                                var name = encodeURIComponent(result.value.name);
                                if(is_template == "is_template"){
                                    window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&post_id="+post_id+"&is_clone=1";
                                }else{
                                    window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&post_id="+post_id;
                                }                                
                            }
                        })
                    }else{
                        if(is_template == "is_template"){
                            window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&post_id="+post_id+"&is_clone=1";
                        }else{
                            window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&post_id="+post_id;
                        }
                    }
                    
				})

				$('.removeMe').on('click', function(){
				    var post_id = $(this).attr('data-id');
                    Swal.fire({
                        title: "<?php echo $this->lang->line('Are You Sure You Want To Delete This Flow?'); ?>",
                        showCancelButton: true,
                        focusConfirm: false,
                        icon: 'error',
                    }).then((result) => {
                        if(result.value){
                            ext_delete_post_id_ajax(post_id);
                        }
                    })				    
				})
				
				$('.shareMe').on('click', function(){
				    var post_id = $(this).attr('data-id');
                    Swal.fire({
                        title: "<?php echo $this->lang->line('Enter User Email You Want To Share With'); ?>",
                        input: 'email',
                        showCancelButton: true,
                        focusConfirm: false,
                        onOpen: () => {
                            $('.swal2-confirm').attr('disabled','true');
                            $('.swal2-input').on('blur',()=>{
                                if( $('.swal2-input').val() == CurrentUserEmail ){
                                    Swal.showValidationMessage(`ERROR: Cannot Share Flow To Your Own Current Account.`);
                                }else if($('.swal2-input').val()){
                                    (async ()=>{
                                        var UserData = await ext_is_user_valid_api($('.swal2-input').val());
                                        if(UserData.status == 1){
                                            $('.swal2-confirm').removeAttr('disabled');
                                        }else{
                                            $('.swal2-confirm').attr('disabled','true');
                                            Swal.showValidationMessage(`ERROR: This User, ${$('.swal2-input').val()}, Does Not Exist.`);
                                        }
                                    })()
                                }
                            })
                        }
                    }).then((result) => {
                        if(result.value){
                            ext_share_flow_ajax(CurrentUserID, result.value, post_id);
                        }
                    })				    
				})
				
				$('.cloneMe').on('click', function(){
				    var post_id = $(this).attr('data-id');
                    var html = '<p><?php echo $this->lang->line("Enter Your Clone Flow\'s Name:"); ?></p><input type="text" id="myFlow_name" class="swal2-input"><div id="PageWrapper" style="display: none;"><p><?php echo $this->lang->line("Select Your New Flow\'s Page:"); ?></p><select class="swal2-select myPages" style="display: flex;"><option value="" disabled=""><?php echo $this->lang->line("Select Page"); ?></option></select></div>';
                    Swal.fire({
                        title: "<?php echo $this->lang->line('Configure Clone Flow'); ?>",
                        html: html,
                        showCancelButton: true,
                        focusConfirm: false,
                        onOpen: () => {
                            (async ()=>{
                                Swal.showLoading();
                                const MyPages3 = await ext_get_user_pages_ajax( CurrentUserID );
                                Swal.hideLoading();
                                $.each(MyPages3, (k,v) => {
                                    $('.myPages').append($(`<option value="${v.page_id}">${v.page_name}</option>`));   
                                })
                                
                                var SSselect = new SlimSelect({
                                  select: '.myPages'
                                })
                                
                                $('#PageWrapper').fadeIn('slow');
                                
                            })()    
                            
                        },
                        preConfirm: () => {
                            
                            if(!$('.myPages').val() || !$("#myFlow_name").val() ){
                                Swal.showValidationMessage(`Error: Values are missing`)
                            }else{
                                return { name: $("#myFlow_name").val(), page_id: $('.myPages').val() };
                            }
                            
                        }
                    }).then((result) => {
                        if(result.value){
                            var page_id = result.value.page_id;
                            var name = encodeURIComponent(result.value.name);
                            window.location.href = CurrentSiteUrl+ "flow_builder/flow/?page_id="+page_id+"&flow_name="+name+"&post_id="+post_id+"&is_clone=1";
                        }
                    })
                    				    
				})
        				
                $('.promoteMe').on('click', function(e){
                    var post_id = $(this).attr('data-id');
                    PromoteToTemplate(post_id);
                });
				
				$('[data-toggle="tooltip"]').tooltip();
				
			},
			"order": [[ 1, "desc" ]]
		});
		
		
	}
	
    function ext_delete_post_id_ajax(delete_post_id_ajax){
        console.log('Delete action started for '+delete_post_id_ajax);
        var domain = CurrentSiteUrl+ "flow_builder/ext_delete_flow_action_ajax";
        $.ajax({
            type: "POST",
            url: domain,
            data: {
                post_id : delete_post_id_ajax,
            },
            success:function( result ) {
                console.log(result);
    			$('#flow_title_'+delete_post_id_ajax).parent().parent().fadeOut(300, function(){ $(this).remove();});
            },
            error: function(errorThrown){
                console.log("ERROR! No Data Submitted");
                console.log(errorThrown);
            }
        });
    }
    
    function ext_delete_google_sheet_ajax(delete_post_id_ajax){
        console.log('Delete action started for '+delete_post_id_ajax);
        var domain = CurrentSiteUrl+ "flow_builder/ext_delete_google_sheet_action_ajax";
        $.ajax({
            type: "POST",
            url: domain,
            data: {
                post_id : delete_post_id_ajax,
            },
            success:function( result ) {
                console.log(result);
    			$('[gs-data-id="'+delete_post_id_ajax+']"').parent().parent().fadeOut(300, function(){ $(this).remove();});
            },
            error: function(errorThrown){
                console.log("ERROR! No Data Submitted");
                console.log(errorThrown);
            }
        });
    }
    
    function ext_is_user_valid_api(user_email_raw){
        
        return new Promise((resolve,reject)=>{
            var domain = CurrentSiteUrl+ "flow_builder/ext_is_user_valid_api_ajax";
            $.ajax({
                type: "POST",
                url: domain,
                data: {
                    user_email : user_email_raw,
                },
                success:function( result ) {
                   	var output = JSON.parse(result);
                   	console.log(output);
                   	resolve(output);
                },
                error: function(errorThrown){
                    console.log(errorThrown);
                }
            });            
        })

    }
    
    function ext_share_flow_ajax(user_id_raw, user_email_raw, post_id_raw){
        var domain = CurrentSiteUrl+ "flow_builder/ext_share_flow";
        $.ajax({
            type: "POST",
            url: domain,
            data: {
                user_email : user_email_raw,
                user_id    : user_id_raw,
                post_id    : post_id_raw,
            },
            success:function( result ) {
               	var output = JSON.parse(result);
               	if(output.status == 1){
               	    swal.fire("<?php echo $this->lang->line("Flow Sharing Complete!"); ?>", "<?php echo $this->lang->line("You have successfully shared your flow to"); ?> "+user_email_raw, "success");
               	}
            },
            error: function(errorThrown){
                swal.fire("<?php echo $this->lang->line("Flow Sharing Failed!"); ?>", "<?php echo $this->lang->line("Please try again..."); ?>", "error");
            }
        });
    }
    
    function ext_check_update(){
            if(CurrentUserType == "Admin" && NeedUpdate == "true"){
                Swal.fire({
                    title: "<?php echo $this->lang->line("Hi Admin! There's A New Version Of Flow Builder."); ?>",
                    text: "<?php echo $this->lang->line("Simply click UPDATE NOW, It's Safe and Quick!"); ?>",
                    showCancelButton: true,
                    focusConfirm: false,
                    confirmButtonText: "UPDATE NOW!",
                    icon: "info"
                }).then((result) => {
                    if(result.value){
                        
                        Swal.fire({
                            title: "<?php echo $this->lang->line('Upate On Progress...'); ?>",
                            html: "<?php echo $this->lang->line('Please wait...'); ?>",
                            timer: 30000,
                            timerProgressBar: true,
                            onBeforeOpen: () => {
                                Swal.showLoading()
                                timerInterval = setInterval(() => {
                                    const content = Swal.getContent()
                                        if (content) {
                                    const b = content.querySelector('b')
                                        if (b) {
                                            b.textContent = Swal.getTimerLeft()
                                        }
                                    }
                                }, 100)
                            },
                            onClose: () => {
                                clearInterval(timerInterval)
                            }
                        })                    
                        
                        var domain = CurrentSiteUrl+ "flow_builder/update";
                        $.ajax({
                            type: "POST",
                            url: domain,
                            success:function( result ) {
                                var _result = JSON.parse(result);
                                console.log(_result);
                                if( _result.status == '1' ){
                                    swal.fire({
                                        title: _result.notice,
                                        text: "<?php echo $this->lang->line("Please click 'OK' to refresh!"); ?>",
                                        icon: "success",
                                    }).then((ant)=>{
                                        if(ant){
                                            window.location.reload()
                                        }
                                    });
                                }else{
                                    swal.fire({
                                        title: _result.notice,
                                        text: "<?php echo $this->lang->line("Please try again..."); ?>",
                                        icon: "error"
                                    }).then((bat)=>{
                                        if(bat){
                                            window.location.reload()
                                        }
                                    });                                    
                                }
                            },
                            error: function(errorThrown){
                                    swal.fire({
                                        title: "<?php echo $this->lang->line("Update Failed!"); ?>",
                                        text: "<?php echo $this->lang->line("Please try again..."); ?>",
                                        icon: "error"
                                    }).then((cat)=>{
                                        if(cat){
                                            window.location.reload()
                                        }
                                    }); 
                            }
                        });                    
                        
                    }
                });            
            }
    
        }
        
    function PromoteToTemplate(post_id_raw){
            if(!post_id_raw){
                console.log("No post ID...");
                return;
            }
            var post_id = post_id_raw;
            var fileinput = '<p><?php echo $this->lang->line('Upload Your Templates Image'); ?></p><div class="dropzone mb-5"><img id="img_icon" src="https://image.flaticon.com/icons/svg/149/149093.svg" srcset="https://image.flaticon.com/icons/svg/149/149093.svg"></div><input id="item_image" type="file" accept="image/*" class="swal2-file" placeholder="" style="display: none;">';
            Swal.fire({
                title: "<?php echo $this->lang->line('Configure New Template'); ?>",
                html: fileinput,
                inputAttributes: {
                accept: 'image/*',
                    'aria-label': "<?php echo $this->lang->line('Configure New Template'); ?>"
                },
                onOpen: function() {

                    $('.dropzone').on("click",function(e){
                        $('#item_image').click();
                    })
                    
                    $('#item_image').on("change",function(){
                        let file = $('#item_image').prop('files');
                        const reader = new FileReader()
                        reader.onload = (e) => {
                            if($('.uploaded_img')){
                                $('.uploaded_img').remove();
                            }
                            var img = $('<img src="'+e.target.result+'" class="uploaded_img">');
                            $('.dropzone').append(img);
                        }
                        if(file){
                            reader.readAsDataURL(file[0])
                        }
                    });

                },
                preConfirm: () => {

                    let file = $('#item_image').prop('files');
                    if( !file){
                        Swal.showValidationMessage("<?php echo $this->lang->line("Error: Values are missing"); ?>")
                    }else{
                        return {"file": file };
                    }
                    
                }
            }).then((data) => {
  
            		try{
            		    var file = data.value.file[0];
            		    var formData = new FormData();
                		formData.append("fileToUpload", file);
                        
                		$.ajax({
                			method: 'post',
                			url: CurrentSiteUrl + "flow_builder/ext_file_upload",
                			data: formData,
                			processData: false,
                			contentType: false,
                			success: function (resp) {
                			    var result = JSON.parse(resp);
                                var image = result.filename;
                                var img = btoa(image);
                                ext_create_new_template_ajax( post_id, img);
                			},
                			error: function (err) {
                				console.log(err);
                				Swal.fire({
                					type: 'error',
                					title: "<?php echo $this->lang->line("Oops..."); ?>",
                					text: "<?php echo $this->lang->line("Something went wrong!"); ?>"
                				})
                			}
                		})
                		
                        Swal.fire({
                            title: "<?php echo $this->lang->line('Promoting...'); ?>",
                            html: "<?php echo $this->lang->line('Please we promote your flow to Template'); ?>",
                            timer: 5000,
                            timerProgressBar: true,
                            onBeforeOpen: () => {
                                Swal.showLoading()
                                timerInterval = setInterval(() => {
                                    const content = Swal.getContent()
                                        if (content) {
                                    const b = content.querySelector('b')
                                        if (b) {
                                            b.textContent = Swal.getTimerLeft()
                                        }
                                    }
                                }, 100)
                            },
                            onClose: () => {
                                clearInterval(timerInterval)
                            }
                        })                		
                		
            		}catch(e){
            		    console.log(e);
            		}
            		
            })        
    }
    
    function ext_create_new_template_ajax(post_id_raw, image_raw){
    		$.ajax({
    			method: 'post',
    			url: CurrentSiteUrl + "flow_builder/ext_create_new_template_ajax",
    			data: {
    			    post_id : post_id_raw,
    			    image   : image_raw,
    			    user_id : CurrentUserID,
    			},
    			success: function (resp) {
    			    var result = JSON.parse(resp);
                    console.log(result);
                    swal.fire("<?php echo $this->lang->line("Successfully Created A New Template!"); ?>", "<?php echo $this->lang->line("Congrats! You have a new template!"); ?>", "success");
                    setTimeout(function(){location.reload(false)},500);
    			},
    			error: function (err) {
    				console.log(err);
    				Swal.fire({
    					type: 'error',
    					title: "<?php echo $this->lang->line("Oops..."); ?>",
    					text: "<?php echo $this->lang->line("Something went wrong!"); ?>"
    				})
    			}
    		})
    }
    
    function ext_delete_template_ajax(post_id_raw){
        var domain = CurrentSiteUrl+ "flow_builder/ext_delete_template_action_ajax";
        $.ajax({
            type: "POST",
            url: domain,
            data: {
                post_id : post_id_raw,
            },
            success:function( result ) {
                console.log(result);
    			$('#template_'+post_id_raw).fadeOut(300, function(){ $(this).remove();window.location.reload();});
            },
            error: function(errorThrown){
                console.log("ERROR! No Data Submitted");
                console.log(errorThrown);
            }
        });
    }
	
    function EditTemplateImage(post_id_raw, template_image_url){
            if(!post_id_raw){
                console.log("No post ID...");
                return;
            }
            var post_id = post_id_raw;
            var fileinput = '<p><?php echo $this->lang->line('Upload A New Image'); ?></p><div class="dropzone mb-5"><img id="img_icon" src="https://image.flaticon.com/icons/svg/149/149093.svg" srcset="https://image.flaticon.com/icons/svg/149/149093.svg"></div><input id="item_image" type="file" accept="image/*" class="swal2-file" placeholder="" style="display: none;">';
            Swal.fire({
                title: "<?php echo $this->lang->line('Change Template Image Here'); ?>",
                html: fileinput,
                inputAttributes: {
                accept: 'image/*',
                    'aria-label': "<?php echo $this->lang->line('Change Template Image Here'); ?>"
                },
                onOpen: function() {

                    $('.dropzone').on("click",function(e){
                        $('#item_image').click();
                    })
                    
                    if(template_image_url){
                        if($('.uploaded_img')){
                            $('.uploaded_img').remove();
                        }
                        var img = $('<img src="'+template_image_url+'" class="uploaded_img">');
                        $('.dropzone').append(img);
                    }
                    
                    $('#item_image').on("change",function(){
                        let file = $('#item_image').prop('files');
                        const reader = new FileReader()
                        reader.onload = (e) => {
                            if($('.uploaded_img')){
                                $('.uploaded_img').remove();
                            }
                            var img = $('<img src="'+e.target.result+'" class="uploaded_img">');
                            $('.dropzone').append(img);
                        }
                        if(file){
                            reader.readAsDataURL(file[0])
                        }
                    });

                },
                preConfirm: () => {

                    let file = $('#item_image').prop('files');
                    if( !file){
                        Swal.showValidationMessage("<?php echo $this->lang->line("Error: Values are missing"); ?>")
                    }else{
                        return {"file": file };
                    }
                    
                }
            }).then((data) => {
  
            		try{
            		    var file = data.value.file[0];
            		    var formData = new FormData();
                		formData.append("fileToUpload", file);
                        
                		$.ajax({
                			method: 'post',
                			url: CurrentSiteUrl + "flow_builder/ext_file_upload",
                			data: formData,
                			processData: false,
                			contentType: false,
                			success: function (resp) {
                			    var result = JSON.parse(resp);
                                var image = result.filename;
                                SaveEditedTemplateImage(image,post_id);
                			},
                			error: function (err) {
                				console.log(err);
                				Swal.fire({
                					type: 'error',
                					title: "<?php echo $this->lang->line("Oops..."); ?>",
                					text: "<?php echo $this->lang->line("Something went wrong!"); ?>"
                				})
                			}
                		})
            		}catch(e){
            		    console.log(e);
            		}
            		
            })        
    }	
	
	function SaveEditedTemplateImage(img_raw,post_id_raw){
		$.ajax({
			method: 'post',
			url: CurrentSiteUrl + "flow_builder/ext_update_template_ajax",
			data: {
			    image : btoa(img_raw),
			    user_id : CurrentUserID,
			    post_id : post_id_raw,
			},
			success: function (resp) {
                var template_image_url = CurrentSiteUrl+"upload/flow_builder/"+CurrentUserID+"/" + img_raw;
                if(resp){
                    $('#template_'+post_id_raw+' img').attr('src',template_image_url);
                    Toast.fire({
                		icon: 'success',
                		title: "<?php echo $this->lang->line("Template Image Successfully Changed!"); ?>"
                	})
                }else{
                    Toast.fire({
                		icon: 'error',
                		title: "<?php echo $this->lang->line("Something went wrong when uploading the new template image.. please try again."); ?>"
                	})                    
                }
			},
			error: function (err) {
				console.log(err);
				Swal.fire({
					type: 'error',
					title: "<?php echo $this->lang->line("Oops..."); ?>",
					text: "<?php echo $this->lang->line("Something went wrong!"); ?>"
				})
			}
		})
	}
	
    function ext_check_usage(module_id_raw){
        
        return new Promise((resolve,reject)=>{
            var domain = CurrentSiteUrl+ "flow_builder/ext_check_usage";
            $.ajax({
                type: "POST",
                data: {
                    module_id: module_id_raw
                },
                url: domain,
                timeout: 5000,
                success:function( result ) {
                    var _result = JSON.parse(result);
                    console.log(_result);
                    resolve(_result);
                },
                error: function(errorThrown){
                    swal.fire("<?php echo $this->lang->line("Ooopppss.. Something went wrong.."); ?>", "<?php echo $this->lang->line('Please try again...'); ?>", "error");
                }
            });          
        })

    };
	
</script>